/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.swparasites.properties;

import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.existingeevee.swparasites.Utils;
import com.existingeevee.swparasites.config.ParasiteSWConfig;
import com.existingeevee.swparasites.handlers.EvolutionHandler;
import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import com.oblivioussp.spartanweaponry.api.SpartanWeaponryAPI;
import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponPropertyWithCallback;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrownWeapon;
import com.oblivioussp.spartanweaponry.item.ItemThrowingWeapon;
import java.text.DecimalFormat;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HeavyWeaponProperty
extends WeaponPropertyWithCallback {
    final boolean lvl2;
    private static AttributeModifier modifier;
    private static AttributeModifier modifierII;
    private static final DecimalFormat FORMATTER;

    public HeavyWeaponProperty(boolean lvl2) {
        super("heavy", "swparasites", lvl2 ? 2 : 1, 0.0f);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.lvl2 = lvl2;
    }

    public void onItemUpdate(ToolMaterialEx material, ItemStack stack, World world, EntityLivingBase entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K) {
            if (ParasiteSWConfig.sentientScent && this.lvl2 && SRPConfigSystems.useScent && world.field_73012_v.nextInt(100) == 0 && entity.field_70173_aa % 40 == 0) {
                entity.func_70690_d(new PotionEffect(SRPPotions.PREY_E, 1200, 0, false, false));
            }
            if (entity.field_70173_aa % 80 == 0) {
                int key = 0;
                NBTTagCompound compound = stack.func_77978_p();
                if (compound != null && EvolutionHandler.getEvolved(stack.func_77973_b()) != null) {
                    if (compound.func_74764_b("srpkills")) {
                        key = compound.func_74762_e("srpkills");
                    }
                    if (key > SRPConfig.weapon_livingSentient_HP_needed) {
                        compound.func_74768_a("srpkills", 0);
                        ItemStack stackW = new ItemStack(EvolutionHandler.getEvolved(stack.func_77973_b()), 1);
                        if (ParasiteSWConfig.evolutionKeepNBT) {
                            stackW.func_77982_d(compound.func_74737_b());
                        }
                        EntityItem entityitem = new EntityItem(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stackW);
                        if (ParasiteSWConfig.evolutionDropOnGround) {
                            entityitem.func_174869_p();
                        } else {
                            entityitem.func_174868_q();
                        }
                        world.func_72838_d((Entity)entityitem);
                        stack.func_190918_g(1);
                        if (SRPConfig.thunderEnable) {
                            world.func_72942_c((Entity)new EntityLightningBolt(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, true));
                        }
                    }
                }
            }
        }
    }

    public void onHitEntity(ToolMaterialEx material, ItemStack stack, EntityLivingBase target, EntityLivingBase attacker, Entity projectile) {
        if (projectile instanceof EntityThrownWeapon) {
            if (!(attacker instanceof EntityPlayer)) {
                return;
            }
            EntityThrownWeapon projThrown = (EntityThrownWeapon)projectile;
            EntityPlayer player = (EntityPlayer)attacker;
            ItemStack weapon = projThrown.getWeaponStack();
            Utils.executeInNTicks(() -> {
                if (target.func_110143_aJ() <= 0.0f) {
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack slotStack = player.field_71071_by.func_70301_a(i);
                        if (!ItemStack.func_185132_d((ItemStack)slotStack, (ItemStack)weapon) || !weapon.func_77942_o() || !slotStack.func_77942_o() || !weapon.func_77978_p().func_186857_a("UUID").equals(slotStack.func_77978_p().func_186857_a("UUID")) || !(weapon.func_77973_b() instanceof ItemThrowingWeapon)) continue;
                        HeavyWeaponProperty.add(slotStack, (int)target.func_110138_aP());
                    }
                }
            }, 1);
        } else if (target.func_110143_aJ() <= 0.0f) {
            HeavyWeaponProperty.add(stack, (int)target.func_110138_aP());
        }
    }

    public static void add(ItemStack stack, int amount) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        if (compound.func_74764_b("srpkills")) {
            int key = compound.func_74762_e("srpkills") + amount;
            compound.func_74768_a("srpkills", key);
        } else {
            compound.func_74768_a("srpkills", amount);
        }
        stack.func_77982_d(compound);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        IAttributeInstance attr;
        IWeaponPropertyContainer container;
        Item item = event.getEntityLiving().func_184614_ca().func_77973_b();
        boolean shouldHaveSlowing = false;
        if (item instanceof IWeaponPropertyContainer && (container = (IWeaponPropertyContainer)item).getAllWeaponProperties().stream().anyMatch(p -> p == this)) {
            shouldHaveSlowing = true;
        }
        if ((attr = event.getEntityLiving().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f)) != null) {
            AttributeModifier modifier;
            AttributeModifier attributeModifier = modifier = this.lvl2 ? HeavyWeaponProperty.getModifierII() : HeavyWeaponProperty.getModifier();
            if (shouldHaveSlowing && !attr.func_180374_a(modifier)) {
                attr.func_111121_a(modifier);
            }
            if (!shouldHaveSlowing && attr.func_180374_a(modifier)) {
                attr.func_111124_b(modifier);
            }
        }
    }

    public WeaponProperty.PropertyQuality getQuality() {
        return WeaponProperty.PropertyQuality.NEGATIVE;
    }

    @SideOnly(value=Side.CLIENT)
    protected void addTooltipDescription(ItemStack stack, List<String> tooltip) {
        String percent = FORMATTER.format((this.lvl2 ? ParasiteSWConfig.weaponIISlowness : ParasiteSWConfig.weaponSlowness) * 100.0);
        tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + "  " + SpartanWeaponryAPI.internalHandler.translateString(this.type + ".desc", "tooltip", this.modId).replace("$s", percent + "%"));
    }

    private static AttributeModifier getModifier() {
        if (modifier == null) {
            modifier = new AttributeModifier(UUID.fromString("aeee73df-79af-4de9-eeee-44b5eee4df1d"), "heavy_weapon_property", -ParasiteSWConfig.weaponSlowness, 2);
        }
        return modifier;
    }

    private static AttributeModifier getModifierII() {
        if (modifierII == null) {
            modifierII = new AttributeModifier(UUID.fromString("aeeee3df-79af-4de9-eeee-44b5eee4df1d"), "heavy_weapon_property", -ParasiteSWConfig.weaponIISlowness, 2);
        }
        return modifierII;
    }

    static {
        FORMATTER = new DecimalFormat("0.##");
    }
}

